/* $Id: e1432i.h,v 1.179 1999/04/23 15:32:15 dhiller Exp $ */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Eric Backus, Don Mathiesen, Don Hiller, and Doug Passey */

/*
   This header file contains definitions which are common to both host
   and the e1432 target but are internal to both and hence not candidates
   for e1432.h.
*/

#ifndef _E1432I_H
#define	_E1432I_H

/*****************************************************************************/
/* Compile flags                                                             */
/*****************************************************************************/

#define	CMD_REG_WORKAROUND

/*****************************************************************************/
/* VXI Registers                                                             */
/*****************************************************************************/

/* SIZEOF() gets the same value in the 96k since the 96k sizeof() is in
   words.  Exceptions are data types that are less than 32 bits or structs
   and arrays containing them.  */
#ifdef	__DSP96K__
#define	REG(_s)		((void *) ((_s) >> 2))
#define SIZEOF(_s)	(sizeof(_s) << 2)
#else
#define	REG(_s)		(_s)
#define SIZEOF(_s)	sizeof(_s)
#endif	/* !__DSP96K__ */

#define	E1432_QUERY_RESPONSE_REG	REG(0x020)
#define	E1432_COMMAND_REG		REG(0x020)
#define	E1432_PARAMETER_1_REG		REG(0x024)
#define	E1432_PARAMETER_2_REG		REG(0x028)
#define	E1432_PARAMETER_3_REG		REG(0x02c)
#define	E1432_PARAMETER_4_REG		REG(0x030)
#define	E1432_FW_MARKER_REG		REG(0x034)
#define	E1432_DATA_AVAIL_REG		REG(0x038)	/* 16 bits used */
#ifdef	CMD_REG_WORKAROUND
#define	E1432_ALT_COMMAND_REG		REG(0x03c)
#endif

/* Empty: 0x40, was DATA_AVAIL  */
#define	E1432_REENABLE_INTERRUPT_REG	REG(0x046)	/* 16 bits used */

/* Catastrophic substrate 96002 firmware errors attempt to leave a
   record of what went wrong in the following locations. */
#define	E1432_INT_ERROR_REG		REG(0x048)
#define	E1432_INT_ERROR_D0_REG		REG(0x04c)
#define	E1432_INT_ERROR_SP_REG		REG(0x050)
#define	E1432_INT_ERROR_SR_REG		REG(0x054)
#define	E1432_INT_ERROR_R6_REG		REG(0x058)
#define	E1432_INT_ERROR_IPR_REG		REG(0x05c)
#define	E1432_INT_ERROR_DCS0_REG	REG(0x060)
#define	E1432_INT_ERROR_DCS1_REG	REG(0x064)

/* Empty: 0x01a*4 - 0x01b*4 = 0x068 - 0x06f = 8 bytes = 2 longwords */

/* Bootrom serial number gets copied here, in packed form */
#define	E1432_SERIAL_START		REG(0x070)	/* 20 bytes long */

/* Empty: 0x021*4 = 0x084 - 0x087 = 4 bytes = 1 longword */

/* This is now in e1432.h, and is part of the API, so it shouldn't be
   moved */
/*#define	E1432_MEAS_WATCHDOG_REG		REG(0x088)*/

/* A buffer of errors, possibly will help debugging something */
#define	E1432_RAW_ERRBUF_SIZE		16		/* longwords */
#define	E1432_RAW_ERRBUF_COUNT_REG	REG(0x08c)
#define	E1432_RAW_ERRBUF_START		REG(0x090)	/* 16 longwords */

/* Empty: 0x034*4 - 0x1bf*4 = 0x0d0 - 0x6ff = 1584 bytes = 396 longwords */

/* diagnostic */
#define E1432_DIAG_FAIL_SCA		REG(0x700)
#define E1432_DIAG_MODES		REG(0x704)

/* defined in e1432.h ... part of API; so don't use this space */
/*#define E1432_CHAN_DATA_MASK_REG    REG(0x708) */

#define	E1432_HPF_SPAN_REG              REG(0x70c)

/* Setup registers that are not per-channel */
#define E1432_OCTAVE_PRESENT_REG	REG(0x710)
#define E1432_OCTAVE_MODE_REG		REG(0x714)
#define E1432_OCTAVE_AVG_MODE_REG	REG(0x718)
#define E1432_OCTAVE_HOLD_MODE_REG	REG(0x71c)
#define E1432_OCTAVE_START_FREQ_REG	REG(0x720)
#define E1432_OCTAVE_STOP_FREQ_REG	REG(0x724)
#define E1432_OCTAVE_INT_TIME_REG	REG(0x728)
#define E1432_OCTAVE_TIME_CONST_REG	REG(0x72c)
#define E1432_OCTAVE_TIME_STEP_REG	REG(0x730)
#define E1432_OCTAVE_BLOCKSIZE_REG	REG(0x734)
/* Empty: save for OCTAVE */
#define E1432_OCTAVE_DEBUG_REG		REG(0x73c)
#define E1432_USER_DECIMATION_REG	REG(0x740)
#define E1432_USER_FRAMES_PER_BLOCK_REG	REG(0x744)
#define E1432_USER_CURRENT_BUF		REG(0x748)
#define E1432_USER_CURRENT_BUF_SIZE	REG(0x74c)
#define E1432_USER1_FRAME_LENGTH_REG	REG(0x750)
#define E1432_USER1_GCD_LENGTH_REG	REG(0x754)
#define E1432_TRIG_HI_REG		REG(0x758)
#define E1432_TRIG_LO_REG		REG(0x75c)
#define E1432_RAW_TACH_SIZE_REG		REG(0x760)
#define	E1432_DECIMATION_UNDERSAMP_REG	REG(0x764)
#define	E1432_INPUT_CHAN_START_REG	REG(0x768)
#define	E1432_TACH_IRQ_NUMBER_REG	REG(0x76c)

#define	E1432_MEAS_TYPE_REG		REG(0x770)
#define	E1432_FIFO_AVAIL_PTR_REG	REG(0x774)
#define	E1432_ENABLE_NONE_FLUSH_REG	REG(0x778)

#define	E1432_PEAK_SPAN_REG             REG(0x77c)

/* Start of the tach parameters on the substrate 32 words */
#define	E1432_TACH_PARMS		REG(0x780)

/* SCA info registers */
#define	E1432_SINFO_REG_OFFSET		((int) REG(0x20)) /* To next SCA */
#define	E1432_SINFO_ID_REG		REG(0x800)
#define	E1432_SINFO_TYPE_REG		REG(0x804)
#define	E1432_SINFO_SLOTS_REG		REG(0x808)
#define	E1432_SINFO_CHANS_REG		REG(0x80c)
#define	E1432_SINFO_BOB_ID_REG		REG(0x810)
#define	E1432_SINFO_CHAN_PER_WORD_REG	REG(0x814)
#define	E1432_SINFO_DATA_SIZE_REG	REG(0x818)
#define	E1432_SINFO_REV_REG		REG(0x81c)

/* General info registers */
#define	E1432_FW_REV_REG		REG(0x8a0)
#define	E1432_DRAM_SIZE_REG		REG(0x8a4)
#define	E1432_LBUS_PRESENT_REG		REG(0x8a8)
#define	E1432_HW_REV_REG		REG(0x8ac)
#define	E1432_BOOTROM_REV_REG		REG(0x8b0)

#define E1432_REQUEST_CHANS_REG         REG(0x8b4)
#define E1432_REQUEST_SPAN_REG          REG(0x8b8)
#define E1432_REQUEST_BLOCKSIZE_REG     REG(0x8bc)
#define E1432_REQUEST_AVG_MODE_REG      REG(0x8c0)
#define E1432_REQUEST_AVG_NUM_REG       REG(0x8c4)
#define E1432_REQUEST_WINDOW_REG        REG(0x8c8)
#define E1432_REQUEST_START_REG         REG(0x8cc)
#define E1432_REQUEST_READY_REG         REG(0x8d0)

/* e1432_get_current_value() return value */
#define E1432_CURRENT_VALUE_REG		REG(0x8d4)
/* more peak/rms parms */
#define E1432_RMS_AVG_TIME_REG		REG(0x8d8)

#define E1432_USER1_BLOCKSIZE_REG	REG(0x8dc)
#define E1432_USER2_BLOCKSIZE_REG	REG(0x8e0)

#define	E1432_FLAGBITS_REG		REG(0x8e4)

/* Setup registers that are not per-channel */
#define	E1432_PEAK_MODE_REG		REG(0x8e8)
#define	E1432_RMS_MODE_REG		REG(0x8ec)

/* This is now in e1432.h, and is part of the API, so it shouldn't be
   moved */
/*#define E1432_SRC_STATUS_REG            REG(0x8f0)*/

/* Setup registers that are not per-channel */
#define	E1432_FREEZE_REG		REG(0x8f4)
#define	E1432_APPEND_STATUS_REG		REG(0x8f8)
#define	E1432_ARM_CHANNEL_REG		REG(0x8fc)
#define	E1432_ARM_MODE_REG		REG(0x900)
#define	E1432_ARM_TIME_INTERVAL_REG	REG(0x904)
#define	E1432_AUTO_TRIGGER_REG		REG(0x908)
#define	E1432_AVG_MODE_REG		REG(0x90c)
#define	E1432_AVG_NUMBER_REG		REG(0x910)
#define	E1432_AVG_UPDATE_REG		REG(0x914)
#define	E1432_AVG_WEIGHT_REG		REG(0x918)
#define	E1432_BLOCKSIZE_REG		REG(0x91c)
#define	E1432_CAL_DAC_REG		REG(0x920)
#define	E1432_CAL_VOLTAGE_REG		REG(0x924)
#define	E1432_CALIN_REG			REG(0x928)
#define	E1432_CENTER_FREQ_REG		REG(0x92c)
#define	E1432_CLOCK_FREQ_REG		REG(0x930)
#define	E1432_CLOCK_MASTER_REG		REG(0x934)
#define	E1432_CLOCK_SOURCE_REG		REG(0x938)
#define	E1432_DATA_MODE_REG		REG(0x93c)
#define	E1432_DATA_PORT_REG		REG(0x940)
#define	E1432_DATA_SIZE_REG		REG(0x944)
#define	E1432_DECIMATION_OUTPUT_REG	REG(0x948)
#define	E1432_DECIMATION_OVERSAMPLE_REG	REG(0x94c)
#define	E1432_DELTA_ORDER_REG		REG(0x950)
#define	E1432_FIFO_SIZE_REG		REG(0x954)
#define	E1432_FILTER_SETTLING_TIME_REG	REG(0x958)
#define	E1432_INTERNAL_DEBUG_REG	REG(0x95c)
#define	E1432_INTERRUPT_MASK_REG	REG(0x960)
#define	E1432_INTERRUPT_PRIORITY_REG	REG(0x964)
#define	E1432_LBUS_MODE_REG		REG(0x968)
#define	E1432_LBUS_RESET_REG		REG(0x96c)
#define	E1432_MAX_ORDER_REG		REG(0x970)
#define	E1432_MEAS_TIME_LENGTH_REG	REG(0x974)
#define	E1432_MULTI_SYNC_REG		REG(0x978)
#define	E1432_OVERLAP_REG		REG(0x97c)
#define	E1432_PRE_ARM_MODE_REG		REG(0x980)
#define	E1432_RAMP_REG			REG(0x984)
#define	E1432_RMS_SPAN_REG              REG(0x988)
#define	E1432_SAMPLE_MODE_REG		REG(0x98c)
#define	E1432_SPAN_REG			REG(0x990)
#define	E1432_SUMBUS_REG		REG(0x994)
#define	E1432_TRIGGER_DELAY_REG		REG(0x998)
#define	E1432_TRIGGER_EXT_REG		REG(0x99c)
#define	E1432_TRIGGER_FLAG_REG		REG(0x9a0)
#define	E1432_TRIGGER_MASTER_REG	REG(0x9a4)
#define	E1432_TRIGGERS_PER_ARM_REG	REG(0x9a8)
#define	E1432_TTLTRG_CLOCK_REG		REG(0x9ac)
#define	E1432_TTLTRG_GCLOCK_REG		REG(0x9b0)
/* On A1 code, REG(0x9b4) is also E1432_STATUS_REG.  The hwinstall program
   still zeros this register because it must work on A1 hardware, and still
   monitors it for the error bit, so don't use it unless hwinstall gets
   modified. */
#define	E1432_TTLTRG_SATRG_REG		REG(0x9b8)
#define	E1432_TTLTRG_TRIGGER_REG	REG(0x9bc)
#define	E1432_WINDOW_REG		REG(0x9c0)
#define	E1432_ZOOM_REG			REG(0x9c4)

/* Status registers that are not per-channel */
#define	E1432_BLOCKSIZE_CURRENT_MAX_REG	REG(0x9c8)
#define	E1432_DECIMATION_REG		REG(0x9cc)

/* Setup register that is not per-channel */
#define	E1432_MMF_DELAY_REG		REG(0x9d0)

/* Status registers that are not per-channel */
#define	E1432_DMA_START_REG		REG(0x9d4)
#define	E1432_LOST_POINT_REG		REG(0x9d8)

/* Setup registers that are not per-channel */
#define	E1432_TRIGGER_SOURCE_REG	REG(0x9dc)

/* Status registers that are not per-channel */
#define	E1432_TRIG_CORR_REG		REG(0x9e0)
#define	E1432_SAMPLES_TO_PRE_ARM_REG	REG(0x9e4)
#define	E1432_TACH_CLOCK_FREQ_REG	REG(0x9e8)
#define	E1432_TACH_DELAY_REG		REG(0x9ec)
#define	E1432_FIFO_SIZE_CURRENT_MAX_REG	REG(0x9f0)

/* Setup registers that are not per-channel */
#define	E1432_XFER_SIZE_REG		REG(0x9f4)
#define E1432_RMS_DECAY_TIME_REG        REG(0x9f8)
#define E1432_PEAK_HOLD_TIME_REG        REG(0x9fc) /* note      address */
#define E1432_PEAK_DECAY_TIME_REG	REG(0x9fc) /*      same         */

/* * * *      W A R N I N G !!!!      * * *
   Don't change the value for CREG_OFFSET without changing
   the corresponding value in peakrms.asm. */
/* Setup registers that are per-channel */
#define	E1432_CREG_OFFSET		((int) REG(0x110)) /* To next chan */
#define	E1432_ACTIVE_CREG		REG(0xa00)
#define E1432_ARM_CHANNEL_PER_INPUT_CREG	REG(0xa04)
#define	E1432_AMP_SCALE_CREG		REG(0xa08)
#define	E1432_ANTI_ALIAS_ANALOG_CREG	REG(0xa0c)
#define	E1432_ANTI_ALIAS_DIGITAL_CREG	REG(0xa10)
#define	E1432_CALC_DATA_CREG		REG(0xa14)
#define	E1432_COUPLING_CREG		REG(0xa18)
#define	E1432_DUTY_CYCLE_CREG		REG(0xa1c)
#define	E1432_FILTER_FREQ_CREG		REG(0xa20)
#define	E1432_INPUT_HIGH_CREG		REG(0xa24)
#define	E1432_MODE_CREG			REG(0xa28)
#define	E1432_PRE_ARM_RPM_CREG		REG(0xa2c)
#define	E1432_RAMP_RATE_CREG		REG(0xa30)
#define	E1432_RANGE_CREG		REG(0xa34)
#define	E1432_RPM_HIGH_CREG		REG(0xa38)
#define	E1432_RPM_INTERVAL_CREG		REG(0xa3c)
#define	E1432_RPM_LOW_CREG		REG(0xa40)
#define	E1432_RPM_SMOOTHING_CREG	REG(0xa44)
#define	E1432_SINE_FREQ_CREG		REG(0xa48)
#define	E1432_SINE_PHASE_CREG		REG(0xa4c)
#define	E1432_SOURCE_BLOCKSIZE_CREG	REG(0xa50)
#define	E1432_SOURCE_CENTERFREQ_CREG	REG(0xa54)
#define	E1432_SOURCE_COLA_CREG		REG(0xa58)
#define	E1432_SOURCE_OUTPUT_CREG	REG(0xa5c)
#define	E1432_SOURCE_SEED_CREG		REG(0xa60)
#define	E1432_SOURCE_SPAN_CREG		REG(0xa64)
#define	E1432_SOURCE_SUM_CREG		REG(0xa68)
#define	E1432_SRCBUFFER_INIT_CREG	REG(0xa6c)
#define	E1432_SRCBUFFER_MODE_CREG	REG(0xa70)
#define	E1432_SRCBUFFER_SIZE_CREG	REG(0xa74)
#define	E1432_TACH_DECIMATE_CREG	REG(0xa78)
#define	E1432_TACH_HOLDOFF_CREG		REG(0xa7c)
#define	E1432_TACH_MAX_TIME_CREG	REG(0xa80)
#define	E1432_TACH_PPR_CREG		REG(0xa84)
#define	E1432_TRIGGER_CHANNEL_CREG	REG(0xa88)
#define	E1432_TRIGGER_LEVEL_LOWER_CREG	REG(0xa8c)
#define	E1432_TRIGGER_LEVEL_UPPER_CREG	REG(0xa90)
#define	E1432_TRIGGER_MODE_CREG		REG(0xa94)
#define	E1432_TRIGGER_SLOPE_CREG	REG(0xa98)
#define	E1432_CAL_OFFSET_CREG		REG(0xa9c)
#define	E1432_CAL_GAIN_CREG		REG(0xaa0)
#define	E1432_CAL_FAILURES_CREG		REG(0xaa4)
/* Status registers that are per-channel */
#define	E1432_CURRENT_RPM_CREG		REG(0xaa8)
#define	E1432_DATA_RPM_CREG		REG(0xaac)
#define	E1432_NEXT_ARM_RPM_CREG		REG(0xab0)
#define	E1432_SCALE_CREG		REG(0xab4)
#define	E1432_SRCOFF_MODE_CREG		REG(0xab8)
#define E1432_RAW_TACH_COUNT_CREG	REG(0xabc)
#define E1432_RAW_TACH_PTR_CREG		REG(0xac0)
#define E1432_COUPLING_FREQ_CREG	REG(0xac4)
#define E1432_WEIGHTING_CREG		REG(0xac8)
#define E1432_INPUT_OFFSET_CREG		REG(0xacc)
#define E1432_AUTOZERO_OFFSET_CREG	REG(0xad0)
#define	E1432_OVLD_INFO_CREG		REG(0xad4)
/* More setup registers that are per-channel */
#define	E1432_ENABLE_FREQ_CREG		REG(0xad8)
#define	E1432_ENABLE_ORDER_CREG		REG(0xadc)
#define	E1432_ENABLE_RESAMPLE_CREG	REG(0xae0)
#define	E1432_ENABLE_TIME_CREG		REG(0xae4)
#define	E1432_INPUT_LOW_CREG		REG(0xae8)
#define	E1432_SRCPARM_MODE_CREG		REG(0xaec)
#define	E1432_CAL_GAIN2_CREG		REG(0xaf0)
#define	E1432_CAL_OFFSET2_CREG		REG(0xaf4)
#define	E1432_RANGE_CHARGE_CREG		REG(0xaf8)
#define	E1432_RANGE_MIKE_CREG		REG(0xafc)
#define E1432_CURRENT_PEAK_CREG         REG(0xb00)
#define E1432_CURRENT_RMS_CREG          REG(0xb04)
#define	E1432_ENABLE_USER1_CREG		REG(0xb08)
#define	E1432_ENABLE_USER2_CREG		REG(0xb0c)

/* Don't go beyond 0xb0c, because the channel increment is 0x110 */

/* Empty: 0x7d0*4 - 0x7ff*4 = 0x1f40 - 0x1fff = 192 bytes = 48 longwords */
/* Firmware system call buffer and registers */
#define	E1432_SYSCALL_BUF_START		REG(0x800 * 4)	/* 80 x 32 */
/* Empty: 0x850*4 - 0xbff*4 = 0x2140 - 0x2fff = 944 longwords */
#define	E1432_SYSCALL_ENABLE		REG(0xc00 * 4)
#define	E1432_SYSCALL_TYPE		REG(0xc01 * 4)
#define	E1432_SYSCALL_1			REG(0xc02 * 4)
#define	E1432_SYSCALL_2			REG(0xc03 * 4)
#define	E1432_SYSCALL_3			REG(0xc04 * 4)

/* New read/write X/Y/P memory address and data locations */
/* These are hardcoded in the bootrom */
#define	E1432_MEMIO_ADDR		REG(0xc10 * 4)
#define	E1432_MEMIO_DATA		REG(0xc11 * 4)

/* Buffer for printf, 80 longwords, 0xc20 - 0xc6f */
#define	E1432_STDIO_BUF_START		REG(0xc20 * 4)	/* 80 x 32 */

/* Empty: 0xc70*4 - 0xc7f*4 = 0x31c0 - 0x31fc = 16 longwords */

/* Limit tables for scas = E1432_SCAS * 32 * E1432_LIM_ENTRIES = 640 longwords,
   0xc80 to 0xeff */
/* individual tables currently have 29 entries so 3 left */
#define	E1432_LIM_SCA			REG(0xc80 * 4)
#define	E1432_LIM_SCA_OFFSET		((int) REG(0x20 * 4)) /* 32 per sca */

/* SCA custom function use */
/* for parameter passing/returning */
#define E1432_SCA_BUF			REG(0x0F00L * 4)
#define E1432_SCA_BUF_SIZE		0x0E0		/* in long words */
/* pointers into E1432_SCA_BUF or E1432_TMP_BUF */
#define E1432_SCA_BUF1_SIZE		REG(0x0FE0L * 4)
#define E1432_SCA_BUF1_PTR		REG(0x0FE1L * 4)
#define E1432_SCA_BUF2_SIZE		REG(0x0FE2L * 4)
#define E1432_SCA_BUF2_PTR		REG(0x0FE3L * 4)

/* handshake registers for current value table r/w coodination */
#define E1432_CVT_LOCK_REQ_REG          REG(0x0FE4L * 4)
#define E1432_CVT_LOCKED_REG            REG(0x0FE5L * 4)

/* Empty: 0xfe6*4 = 1 longwords */

/* Pointers to the arb source data buffers.  Normally these will point
   to the source buffers (xxx_START_REG) defined below, but they may
   sometimes point to DRAM instead.  These MUST remain contiguous and
   in order. */
#define	E1432_SRC0_XFRBUFPTR_REG	REG(0x0fe7 * 4)
#define	E1432_SRC0_2_XFRBUFPTR_REG	REG(0x0fe8 * 4)
#define	E1432_SRC2_XFRBUFPTR_REG	REG(0x0fe9 * 4)
#define	E1432_SRC2_2_XFRBUFPTR_REG	REG(0x0fea * 4)
#define	E1432_SRC4_XFRBUFPTR_REG	REG(0x0feb * 4)

/* ARB Source data transfer buffers in B-bus SRAM, 4096 wds max each */
/* Source Daughter board is SCA 4, 2 channel sources are SCA 0 and 2 */
/* SCA 0 channel 2 */
#define E1432_SRC0_2_XFRA_STATUS_REG	REG(0x0FECL * 4)
#define E1432_SRC0_2_XFRB_STATUS_REG	REG(0x0FEDL * 4)
#define E1432_SRC0_2_XFRCMD_REG		REG(0x0FEEL * 4)
#define E1432_SRC0_2_XFRBUFFER_WORDCOUNT_REG REG(0x0FEFL * 4)
/* SCA 2 channel 2 */
#define E1432_SRC2_2_XFRA_STATUS_REG	REG(0x0FF0L * 4)
#define E1432_SRC2_2_XFRB_STATUS_REG	REG(0x0FF1L * 4)
#define E1432_SRC2_2_XFRCMD_REG		REG(0x0FF2L * 4)
#define E1432_SRC2_2_XFRBUFFER_WORDCOUNT_REG REG(0x0FF3L * 4)
/* SCA 0 channel 1 */
#define E1432_SRC0_XFRA_STATUS_REG	REG(0x0FF4L * 4)
#define E1432_SRC0_XFRB_STATUS_REG	REG(0x0FF5L * 4)
#define E1432_SRC0_XFRCMD_REG		REG(0x0FF6L * 4)
#define E1432_SRC0_XFRBUFFER_WORDCOUNT_REG REG(0x0FF7L * 4)
/* SCA 2 channel 1 */
#define E1432_SRC2_XFRA_STATUS_REG	REG(0x0FF8L * 4)
#define E1432_SRC2_XFRB_STATUS_REG	REG(0x0FF9L * 4)
#define E1432_SRC2_XFRCMD_REG		REG(0x0FFAL * 4)
#define E1432_SRC2_XFRBUFFER_WORDCOUNT_REG REG(0x0FFBL * 4)
/* SCA 4 (daughter board) channel 1 */
#define E1432_SRC4_XFRA_STATUS_REG	REG(0x0FFCL * 4)
#define E1432_SRC4_XFRB_STATUS_REG	REG(0x0FFDL * 4)
#define E1432_SRC4_XFRCMD_REG		REG(0x0FFEL * 4)
#define E1432_SRC4_XFRBUFFER_WORDCOUNT_REG REG(0x0FFFL * 4)

/**************************************************************************/
/**************************************************************************/
/* WARNING: the space for the order CVT will overlay the clarinet 
 * daughter board buffer .... it is assumed that this is ok, since 
 * order requires a tach board and multiple modules order tracking 
 * is not allow in EDF configuration
 */
/**************************************************************************/
/**************************************************************************/
/* order current value table of 4096 words ( 2 * CVT_SIZE * INPUT_CHANS) */
/*#define E1432_ORDER_CVT_SIZE            128  defined in e1432.h */
#define E1432_ORDER_CVT                 REG(0x1000L * 4)

/* Clarinet (daughter board) buffer */
#define E1432_SRC4_XFRBUFFER_START_REG	REG(0x1000L * 4)

/*  Clarion buffers (shared with SCA DSP download  */
#define E1432_SRC0_XFRBUFFER_START_REG	REG(0x4000L * 4)
#define E1432_SRC0_2_XFRBUFFER_START_REG REG(0x5000L * 4)
#define E1432_SRC2_XFRBUFFER_START_REG	REG(0x6000L * 4)
#define E1432_SRC2_2_XFRBUFFER_START_REG REG(0x7000L * 4)

/* 0x4000 to 0x7FFFF used to download programs to SCA DSPs */
/* shared with Clarion source xfr buffers */
#define E1432_SCA_DBUF			REG(0x4000L * 4)
#define E1432_SCA_DBUF_SIZE		0x4000L		/* 32 bit words */

/* FFT windows */
#define	E1432_WINDOW_START		REG(0x2000L * 4)

/* Hardware registers */
#define	E1432_MEM_CTL_START		REG(0x2000L * 4) /* 256 x 32 */
#define	E1432_CLOCK_TRIG_START		REG(0x2100L * 4) /* 256 x 32 */
#define	E1432_FIT_START			REG(0x2200L * 4) /* 256 x 32 */

/* 96000 B-bus Host Port */
#define	E1432_HOSTB_START		REG(0x2300L * 4) /* 256 x 32 */
#define	E1432_HOSTB_ICS_REG		REG(0x2320L * 4)
#define	E1432_HOSTB_RXTX_REG		REG(0x2328L * 4)
#define	E1432_HOSTB_CVR_REG		REG(0x2334L * 4)
#define	E1432_HOSTB_Y_WRITE_REG		REG(0x2300L * 4)
#define	E1432_HOSTB_Y_READ_REG		REG(0x2304L * 4)
#define	E1432_HOSTB_X_WRITE_REG		REG(0x2308L * 4)
#define	E1432_HOSTB_X_READ_REG		REG(0x230CL * 4)

/* 96000 Hostport bit definitions */
#define	E1432_HOSTB_ICS_RXDF            0x00000001
#define	E1432_HOSTB_ICS_TXDE            0x00000002
#define	E1432_HOSTB_ICS_HF0             0x00000100
#define	E1432_HOSTB_ICS_HF1             0x00000200
#define	E1432_HOSTB_ICS_DMAE            0x00001000
#define	E1432_HOSTB_ICS_HRST            0x00002000
#define	E1432_HOSTB_ICS_HMRC		0x00008000L
#define	E1432_HOSTB_CVR_HOSTACMD        0x0000800eL
#ifdef	CMD_REG_WORKAROUND
#define	E1432_HOSTB_CVR_VXICMD		0x00008020L
#endif
#define	E1432_HOSTB_CVR_HC              0x00008000L
/* 96002-side hostport bit definitions */
#define	E1432_HOSTB_HCR_HTIE		0x00000002

/* End of dedicated registers, start of SRAM FIFO (if used) */
#define	E1432_FIFO_START		REG(0x4000L * 4) /* up to 0x80000 */

/* A-bus addresses */
#define	E1432_SCA_START			REG(0x100000L * 4)
#define	E1432_SCA_OFFSET		((int) REG(0x100 * 4))
#define	E1432_LBUS_START		REG(0x400000L * 4)
#define	E1432_LBUS_FIFO_START		REG(0x500000L * 4)
#define	E1432_DRAM_START		REG(0x1000000L * 4)

/* Hardware FIFO on VXI side only */
#define	E1432_HW_FIFO_START		0x20000L
#define	E1432_HW_FIFO_SIZE		0x10000L


/*****************************************************************************/
/* Commands that can be sent to command register                             */
/*****************************************************************************/

/* All query commands MUST have bit 0x1000 set */
/* Setup commands that are not per-channel */
#define	E1432_CMD_SET_APPEND_STATUS	0x101
#define	E1432_CMD_SET_ARM_CHANNEL	0x102
#define	E1432_CMD_SET_ARM_MODE		0x103
#define	E1432_CMD_SET_ARM_TIME_INTERVAL	0x104
#define	E1432_CMD_SET_AUTO_TRIGGER	0x105
#define	E1432_CMD_SET_AVG_MODE		0x106
#define	E1432_CMD_SET_AVG_NUMBER	0x107
#define	E1432_CMD_SET_AVG_UPDATE	0x108
#define	E1432_CMD_SET_AVG_WEIGHT	0x109
#define	E1432_CMD_SET_BLOCKSIZE		0x10a
#define	E1432_CMD_SET_CAL_DAC		0x10b
#define	E1432_CMD_SET_CAL_VOLTAGE	0x10c
#define	E1432_CMD_SET_CALIN		0x10d
#define	E1432_CMD_SET_CENTER_FREQ	0x10e
#define	E1432_CMD_SET_CLOCK_FREQ	0x10f
#define	E1432_CMD_SET_CLOCK_MASTER	0x110
#define	E1432_CMD_SET_CLOCK_SOURCE	0x111
#define	E1432_CMD_SET_DATA_MODE		0x112
#define	E1432_CMD_SET_DATA_PORT		0x113
#define	E1432_CMD_SET_DATA_SIZE		0x114
#define	E1432_CMD_SET_DECIMATION_OUTPUT	0x115
#define	E1432_CMD_SET_DECIMATION_OVERSAMPLE	0x116
#define	E1432_CMD_SET_DELTA_ORDER	0x117
#define	E1432_CMD_SET_FIFO_SIZE		0x118
#define	E1432_CMD_SET_FILTER_SETTLING_TIME	0x119
#define	E1432_CMD_SET_INTERNAL_DEBUG	0x11a
#define	E1432_CMD_SET_INTERRUPT_MASK	0x11b
#define	E1432_CMD_SET_INTERRUPT_PRIORITY	0x11c
#define	E1432_CMD_SET_LBUS_MODE		0x11d
#define	E1432_CMD_SET_LBUS_RESET	0x11e
#define	E1432_CMD_SET_MAX_ORDER		0x11f
#define	E1432_CMD_SET_MEAS_TIME_LENGTH	0x120
#define	E1432_CMD_SET_MULTI_SYNC	0x121
#define	E1432_CMD_SET_OVERLAP		0x122
#define	E1432_CMD_SET_PRE_ARM_MODE	0x123
#define	E1432_CMD_SET_RAMP		0x124
#define	E1432_CMD_SET_SAMPLE_MODE	0x125
#define	E1432_CMD_SET_SPAN		0x126
#define	E1432_CMD_SET_SUMBUS		0x127
#define	E1432_CMD_SET_TRIGGER_DELAY	0x128
#define	E1432_CMD_SET_TRIGGER_EXT	0x129
#define	E1432_CMD_SET_TRIGGERS_PER_ARM	0x12a
#define	E1432_CMD_SET_TTLTRG_CLOCK	0x12b
#define	E1432_CMD_SET_TTLTRG_GCLOCK	0x12c
#define	E1432_CMD_SET_TTLTRG_SATRG	0x12d
#define	E1432_CMD_SET_TTLTRG_TRIGGER	0x12e
#define	E1432_CMD_SET_WINDOW		0x12f
#define	E1432_CMD_SET_ZOOM		0x130
#define	E1432_CMD_SET_RMS_SPAN          0x131
#define	E1432_CMD_SET_TRIGGER_FLAG	0x132
#define	E1432_CMD_SET_TRIGGER_MASTER	0x133
#define	E1432_CMD_SET_XFER_SIZE		0x134
#define	E1432_CMD_DSP_DOWNLOAD		0x135
#define E1432_CMD_SET_RMS_DECAY_TIME    0x136
#define E1432_CMD_SET_PEAK_HOLD_TIME    0x137
#define	E1432_CMD_DSP_EXEC_QUERY	0x138
#define	E1432_CMD_SET_TRIGGER_SOURCE	0x139
#define	E1432_CMD_SET_FREEZE		0x13a
#define	E1432_CMD_SET_MMF_DELAY		0x13b
#define	E1432_CMD_SET_PEAK_MODE		0x13c
#define	E1432_CMD_SET_RMS_MODE		0x13d
#define	E1432_CMD_GET_CURRENT_VALUE	0x13e
#define E1432_CMD_SET_RMS_AVG_TIME	0x13f
#define E1432_CMD_SET_PEAK_DECAY_TIME	0x140
#define E1432_CMD_SET_OCTAVE_MODE	0x141
#define E1432_CMD_SET_OCTAVE_AVG_MODE	0x142
#define E1432_CMD_SET_OCTAVE_HOLD_MODE	0x143
#define E1432_CMD_SET_OCTAVE_START_FREQ	0x144
#define E1432_CMD_SET_OCTAVE_STOP_FREQ	0x145
#define E1432_CMD_SET_OCTAVE_INT_TIME	0x146
#define E1432_CMD_SET_OCTAVE_TIME_CONST	0x147
#define E1432_CMD_SET_OCTAVE_TIME_STEP	0x148
#define E1432_CMD_SET_USER_DECIMATION	0x149
#define E1432_CMD_SET_USER_FRAMES_PER_BLOCK	0x14a
#define	E1432_CMD_SET_TRIG_HI		0x14b
#define	E1432_CMD_SET_TRIG_LO		0x14c
#define	E1432_CMD_SET_DECIMATION_UNDERSAMP	0x14d
#define	E1432_CMD_SET_TACH_IRQ_NUMBER	0x14e
#define	E1432_CMD_SET_MEAS_TYPE		0x14f
#define	E1432_CMD_SET_PEAK_SPAN         0x150
#define	E1432_CMD_SET_HPF_SPAN          0x151

/* Setup commands that are per-channel */
#define	E1432_CCMD_SET_ACTIVE		0x201
/* defunct E1432_CCMD_SET_AC_SETTLING	0x202 */
#define	E1432_CCMD_SET_AMP_SCALE	0x203
#define	E1432_CCMD_SET_ANTI_ALIAS_ANALOG	0x204
#define	E1432_CCMD_SET_ANTI_ALIAS_DIGITAL	0x205
#define E1432_CCMD_SET_ARM_CHANNEL_PER_INPUT    0x206
#define	E1432_CCMD_SET_AUTO_ZERO	0x207
#define	E1432_CCMD_SET_COUPLING		0x208
#define	E1432_CCMD_SET_DUTY_CYCLE	0x209
#define	E1432_CCMD_SET_FILTER_FREQ	0x20a
#define	E1432_CCMD_SET_INPUT_HIGH	0x20b
#define	E1432_CCMD_SET_MODE		0x20c
#define	E1432_CCMD_SET_CALC_DATA	0x20d
#define	E1432_CCMD_SET_PRE_ARM_RPM	0x20e
#define	E1432_CCMD_SET_RAMP_RATE	0x20f
#define	E1432_CCMD_SET_RANGE		0x210
#define	E1432_CCMD_SET_RPM_HIGH		0x211
#define	E1432_CCMD_SET_RPM_INTERVAL	0x212
#define	E1432_CCMD_SET_RPM_LOW		0x213
#define	E1432_CCMD_SET_RPM_SMOOTHING	0x214
#define	E1432_CCMD_SET_SINE_FREQ	0x215
#define	E1432_CCMD_SET_SINE_PHASE	0x216
#define	E1432_CCMD_SET_SOURCE_BLOCKSIZE	0x217
#define	E1432_CCMD_SET_SOURCE_CENTERFREQ	0x218
#define	E1432_CCMD_SET_SOURCE_COLA	0x219
#define	E1432_CCMD_SET_SOURCE_OUTPUT	0x21a
#define	E1432_CCMD_SET_SOURCE_SEED	0x21b
#define	E1432_CCMD_SET_SOURCE_SPAN	0x21c
#define	E1432_CCMD_SET_SOURCE_SUM	0x21d
#define	E1432_CCMD_SET_SRCBUFFER_INIT	0x21e
#define	E1432_CCMD_SET_SRCBUFFER_MODE	0x21f
#define	E1432_CCMD_SET_SRCBUFFER_SIZE	0x220
#define	E1432_CCMD_SET_TACH_DECIMATE	0x221
#define	E1432_CCMD_SET_TACH_HOLDOFF	0x222
#define	E1432_CCMD_SET_TACH_MAX_TIME	0x223
#define	E1432_CCMD_SET_TACH_PPR		0x224
#define	E1432_CCMD_SET_TRIGGER_CHANNEL	0x225
#define	E1432_CCMD_SET_TRIGGER_LEVEL_LOWER	0x226
#define	E1432_CCMD_SET_TRIGGER_LEVEL_UPPER	0x227
#define	E1432_CCMD_SET_TRIGGER_MODE	0x228
#define	E1432_CCMD_SET_TRIGGER_SLOPE	0x229
#define	E1432_CCMD_SET_COUPLING_FREQ	0x22a
#define	E1432_CCMD_SET_WEIGHTING	0x22b
#define	E1432_CCMD_SET_INPUT_OFFSET	0x22c
#define	E1432_CCMD_SET_AUTOZERO_OFFSET	0x22d
#define	E1432_CCMD_SET_SRCPARM_MODE	0x22e
#define	E1432_CCMD_SET_ENABLE_FREQ	0x22f
#define	E1432_CCMD_SET_ENABLE_ORDER	0x230
#define	E1432_CCMD_SET_ENABLE_RESAMPLE	0x231
#define	E1432_CCMD_SET_ENABLE_TIME	0x232
#define	E1432_CCMD_SET_INPUT_LOW	0x233
#define	E1432_CCMD_SET_RANGE_CHARGE	0x234
#define	E1432_CCMD_SET_RANGE_MIKE	0x235
#define	E1432_CCMD_SET_ENABLE_USER1	0x236
#define	E1432_CCMD_SET_ENABLE_USER2	0x237
#define	E1432_CCMD_SET_USER_DATA	0x238
#define	E1432_CCMD_SET_WINDOW_SCALE	0x239
#define	E1432_CCMD_DSP_DOWNLOAD		0x240
#define	E1432_CCMD_SET_SRCOFF_MODE	0x241

/* Parameter limit query commands that are not per-channel */
/* #define	E1432_CMD_LGET_ARM_TIME_INTERVAL 0x1301 */
/* #define	E1432_CMD_LGET_AVG_NUMBER	0x1302 */
/* #define	E1432_CMD_LGET_AVG_UPDATE	0x1303 */
/* #define	E1432_CMD_LGET_AVG_WEIGHT	0x1304 */
#define	E1432_CMD_LGET_BLOCKSIZE	0x1305
/* #define	E1432_CMD_LGET_CAL_DAC		0x1306 */
/* #define	E1432_CMD_LGET_CAL_VOLTAGE	0x1307 */
/* #define	E1432_CMD_LGET_CENTER_FREQ	0x1308 */
/* #define	E1432_CMD_LGET_CLOCK_FREQ	0x1309 */
/* #define	E1432_CMD_LGET_DELTA_ORDER	0x130a */
#define	E1432_CMD_LGET_FIFO_SIZE	0x130b
/* #define	E1432_CMD_LGET_FILTER_SETTLING_TIME	0x130c */
/* #define	E1432_CMD_LGET_INTERNAL_DEBUG	0x130d */
/* #define	E1432_CMD_LGET_INTERRUPT_PRIORITY	0x130e */
/* #define	E1432_CMD_LGET_MEAS_TIME_LENGTH 0x130f */
/* #define	E1432_CMD_LGET_MAX_ORDER	0x1310 */
#define	E1432_CMD_LGET_OVERLAP		0x1311
/* #define	E1432_CMD_LGET_SPAN		0x1312 */
#define	E1432_CMD_LGET_TRIGGER_DELAY	0x1313
/* #define	E1432_CMD_LGET_TRIGGERS_PER_ARM	0x1314 */
/* #define	E1432_CMD_LGET_RMS_SPAN         0x1315 */
/* #define	E1432_CMD_LGET_TRIGGER_FLAG	0x1316 */
/* #define	E1432_CMD_LGET_TRIGGER_MASTER	0x1317 */
#define	E1432_CMD_LGET_XFER_SIZE	0x1318
/* #define E1432_CMD_LGET_RMS_DECAY_TIME   0x1319 */
/* #define E1432_CMD_LGET_RMS_AVG_TIME	0x131a */
/* #define E1432_CMD_LGET_PEAK_HOLD_TIME   0x131b */
/* #define E1432_CMD_LGET_PEAK_DECAY_TIME	0x131c */
/* #define E1432_CMD_LGET_OCTAVE_START_FREQ	0x131d */
/* #define E1432_CMD_LGET_OCTAVE_STOP_FREQ	0x131e */
/* #define E1432_CMD_LGET_OCTAVE_INT_TIME	0x131f */
/* #define E1432_CMD_LGET_OCTAVE_TIME_CONST	0x1320 */
/* #define E1432_CMD_LGET_OCTAVE_TIME_STEP	0x1321 */
/* #define	E1432_CMD_LGET_TRIG_HI		0x1322 */
/* #define	E1432_CMD_LGET_TRIG_LO		0x1323 */
/* #define	E1432_CMD_LGET_RAW_TACH_SIZE	0x1324 */
/* #define	E1432_CMD_LGET_DECIMATION_UNDERSAMP	0x1325 */
/* #define	E1432_CMD_LGET_TACH_IRQ_NUMBER	0x1326 */

/* Action commands that are not per-channel */
/* Unused: 0x501 */
#define	E1432_CMD_AUTO_ZERO		0x502
/* Unused: 0x503 */
#define	E1432_CMD_GLOBAL_PRESET		0x504
#define	E1432_CMD_NOP			0x505
#define	E1432_CMD_PRE_ARM_MEASURE	0x506
#define	E1432_CMD_READ_ERROR		0x1507
#define	E1432_CMD_READ_WARNING		0x1508
#define	E1432_CMD_REENABLE_INTERRUPT	0x508
#define	E1432_CMD_RESET			0x509
#define	E1432_CMD_RESET_MEASURE_START	0x50a
#define	E1432_CMD_RESET_MEASURE_FINISH	0x50b
#define	E1432_CMD_SELFTEST		0x50c
#define	E1432_CMD_SYNC			0x50d
#define	E1432_CMD_TEST_LBUS		0x50e
#define	E1432_CMD_FLUSH_SCAN_DATA	0x50f
#define	E1432_CMD_SETTLE		0x510
#define	E1432_CMD_OVLD_UPDATE		0x511
#define	E1432_CMD_OCTAVE_CTL		0x512
#define	E1432_CMD_SNAP_CURRENT_DATA	0x513
#define	E1432_CMD_RESET_MEASURE_MIDDLE	0x514

/* Action commands that are per-channel */
#define	E1432_CCMD_PRESET		0x601
#define	E1432_CCMD_READ_OVERLOAD	0x1602
#define	E1432_CCMD_RAW_TACHS_DONE	0x603
#define	E1432_CCMD_READ_I2C_BYTE	0x1604
#define	E1432_CCMD_WRITE_I2C_BYTE	0x605
#define	E1432_CCMD_UPDATE_SRCPARM	0x606


/* Limit tables */
#define	E1432_LIM_ENTRIES		4       /* min, max, def, step */

/* index of individual limit parms */
#define	E1432_LIM_MIN			0
#define	E1432_LIM_MAX			1
#define	E1432_LIM_DEF			2
#define	E1432_LIM_STEP			3

/* indexes into sca limit tables, E1432_LIM_SCA & E1432_LIM_SCA_OFFSET */
#define	E1432_LIM_SCA_AMP_SCALE			((int) REG(0x00 * 4))
/* chan_clock_freq not a user-settable parameter */
#define	E1432_LIM_SCA_CHAN_CLOCK_FREQ		((int) REG(0x01 * 4))
#define	E1432_LIM_SCA_DUTY_CYCLE		((int) REG(0x02 * 4))
#define	E1432_LIM_SCA_FILTER_FREQ		((int) REG(0x03 * 4))
#define	E1432_LIM_SCA_PRE_ARM_RPM		((int) REG(0x04 * 4))
#define	E1432_LIM_SCA_RAMP_RATE			((int) REG(0x05 * 4))
#define	E1432_LIM_SCA_COUPLING_FREQ		((int) REG(0x06 * 4))
#define	E1432_LIM_SCA_RANGE			((int) REG(0x07 * 4))
#define	E1432_LIM_SCA_RANGE_CHARGE		((int) REG(0x08 * 4))
#define	E1432_LIM_SCA_RANGE_MIKE		((int) REG(0x09 * 4))
#define	E1432_LIM_SCA_INPUT_OFFSET		((int) REG(0x0a * 4))
#define	E1432_LIM_SCA_AUTOZERO_OFFSET		((int) REG(0x0b * 4))
#define	E1432_LIM_SCA_RPM_HIGH			((int) REG(0x0c * 4))
#define	E1432_LIM_SCA_RPM_INTERVAL		((int) REG(0x0d * 4))
#define	E1432_LIM_SCA_RPM_LOW			((int) REG(0x0e * 4))
#define	E1432_LIM_SCA_RPM_SMOOTHING		((int) REG(0x0f * 4))
#define	E1432_LIM_SCA_SINE_FREQ			((int) REG(0x10 * 4))
#define	E1432_LIM_SCA_SINE_PHASE		((int) REG(0x11 * 4))
#define	E1432_LIM_SCA_SOURCE_BLOCKSIZE		((int) REG(0x12 * 4))
#define	E1432_LIM_SCA_SOURCE_CENTERFREQ		((int) REG(0x13 * 4))
#define	E1432_LIM_SCA_SOURCE_SEED		((int) REG(0x14 * 4))
#define	E1432_LIM_SCA_SOURCE_SPAN		((int) REG(0x15 * 4))
#define	E1432_LIM_SCA_SRCBUFFER_SIZE		((int) REG(0x16 * 4))
#define	E1432_LIM_SCA_TACH_DECIMATE		((int) REG(0x17 * 4))
#define	E1432_LIM_SCA_TACH_HOLDOFF		((int) REG(0x18 * 4))
#define	E1432_LIM_SCA_TACH_MAX_TIME		((int) REG(0x19 * 4))
#define	E1432_LIM_SCA_TACH_PPR			((int) REG(0x1a * 4))
#define	E1432_LIM_SCA_TRIGGER_LEVEL_LOWER	((int) REG(0x1b * 4))
#define	E1432_LIM_SCA_TRIGGER_LEVEL_UPPER	((int) REG(0x1c * 4))
/* defined for 32 entries, room for 3 more entires */


/* xxx_PAGE values are written to E1432_PAGE_MAP_REG to move the
   movable A24 memory window.

   For the 1MB version of the VXI interface, the lsb of the page map
   register is DSP A(17), so 1 selects DSP address 0x20000.  Page map
   bits 6 and 7 select where this gets mapped into 96002 address
   space.  Bits 7,6 = 00 selects the bottom of B bus, where the B bus
   SRAM is.  Bits 7,6 = 01 sets A(24) and selects A bus, resulting in
   access to DRAM.  Bits 7,6 = 10 selects the bottom of A bus, where
   the A bus SRAM is.  Bits 7,6 = 11 sets A(24), A(30), and A(31) and
   selects B bus, resulting in access to the flash ROM.

   For the 256KB version of the VXI interface, the page map is similar
   but has two extra bits at the bottom.  So the bits which control
   which bus are 8 and 9 instead of 6 and 7.  A 1 in the page map
   register selects DSP address 0x8000.

   These xxx_PAGE values are for the 1 MB version of the VXI
   interface.  For the 256K version, these values need to be shifted
   up by two bits. */

#define	E1432_BASE_PAGE		0x00
#define	E1432_FIT_PAGE		0x00
#define	E1432_VPP_PAGE		0x00
#define	E1432_B_SRAM_PAGE	0x01
#define	E1432_DRAM_PAGE		0x40
#define	E1432_A_SRAM_PAGE	0x80
#define	E1432_SCA_PAGE		0x88
#define	E1432_FPROM_PAGE	0xFF

/* _BASE values are the starting address of a FIT device or SCA slot,
 * after setting the page map register (above).  Address units are
 * vxi-relative-to-module-A24-start. 0x00080000 is added to select the
 * movable window for 1MB A24 modules, or 0x00020000 is added to
 * select the movable window for 256K A24 modules. *4 converts DSP
 * addresses to VXI addresses */

#define E1432_FIT_BASE		(0x2200UL * 4)
#define E1432_SCA0_BASE		(0x0000UL * 4)
#define E1432_SCA1_BASE		(0x0100UL * 4)
#define E1432_SCA2_BASE		(0x0200UL * 4)
#define E1432_SCA3_BASE		(0x0300UL * 4)
#define	E1432_WINDOW_BASE_1M	0x00080000UL
#define	E1432_WINDOW_BASE_256K	0x00020000UL

/*****************************************************************************/
/* Clari definitions                                                         */
/*****************************************************************************/

#define E1432_SCA_FIT		4	/* SCA number of FIT device */
#define E1432_SCA_CLARION_1	0	/* sca number of Clarion 1 */
#define E1432_SCA_CLARION_2	2	/* sca number of Clarion 2 */

/* these are Clariet/Clarion register addresses relative to SCA base,
 * in VXI bus address units. */
#define E1432_SRC_ID_REG	0x00
#define E1432_SRC_SISR		0x20
#define E1432_SRC_CVR		0x90
#define E1432_SRC_RTXL		0xf0
#define E1432_SRC_RTXM		0xe0
#define E1432_SRC_RTXH		0xd0

/* Clarinet/Clarion commands */
#define E1432_CLARI_SRCBOOT			0x92000000UL
#define E1432_CLARI_IDREAD			0x98000000UL
#define E1432_CLARI_IDREAD2			0x9e000000UL
#define E1432_CLARI_MONEXTMSG			0xa2000000UL
#define E1432_CLARI_MONHPDCMDBUF		0xa3000000UL
#define E1432_CLARI_MONECHOMD			0xa4000000UL
#define E1432_CLARI_MONERASE			0xa5000000UL
#define E1432_CLARI_MONFLASHPROG		0xa6000000UL
#define E1432_CLARI_MONSRCOFF			0xb3000000UL
#define E1432_CLARI_MONCMD_WDWRITE		0x00000100UL
#define E1432_CLARI_MONCMD_WDREAD		0x00000200UL
#define E1432_CLARI_MONCMD_ADCREAD		0x00000500UL
#define E1432_CLARI_MONCMD_BDPARMS		0x00000600UL
#define E1432_CLARI_MONCMD_BDPARMSRD		0x00000700UL
#define E1432_CLARI_MONCMD_BDPARMSRESET		0x00000800UL
#define E1432_CLARI_MONCMD_BDPARMSSTORE		0x00000900UL
#define E1432_CLARI_MONCMD_BLKWRITE		0x00000e00UL
#define E1432_CLARI_MONCMD_ERASEPARMS		0x1d000200UL
#define E1432_CLARI_MONCMD_ERASESYS		0x1d000300UL
#define E1432_CLARI_MONCMD_PROGSYS		0x1e000100UL
#define E1432_CLARI_MONCMD_PROGPARMS		0x1e000200UL
#define E1432_CLARI_ONE				0x00000100UL
#define E1432_CLARI_SINE2_NOOVERREAD		0xb7000000UL
#define E1432_CLARI_SINE2_OVERREAD		0xb8000000UL
/* upper 5 bits of ID register identify Clarinet */
#define E1432_CLARI_ID_BITS			0xf8000000UL
#define E1432_CLARINET_ID			0x30000000UL
#define E1432_CLARION_ID			0x38000000UL
#define E1432_CLARI_SISR_CMDACK			0x00200000UL
#define E1432_CLARI_BLOCK_SIZE			60

/* for wdread/wdwrite */
#define E1432_CLARI_Y_SPACE			0x00000000UL
#define E1432_CLARI_X_SPACE			0x00000100UL
#define E1432_CLARI_P_SPACE			0x00000200UL

/* for adcread */
#define E1432_CLARINET_ADC_CHAN_AMPOUT		0x00000000UL
#define E1432_CLARINET_ADC_CHAN_DACOUT		0x00000100UL
#define E1432_CLARINET_ADC_CHAN_RDACOUT		0x00000200UL
#define E1432_CLARINET_ADC_CHAN_AMPOUT_HIGAIN	0x00000300UL
#define E1432_CLARINET_ADC_CHAN_CALOUT		0x00000400UL
#define E1432_CLARINET_ADC_CHAN_VREF		0x00000500UL
#define E1432_CLARINET_ADC_CHAN_GND		0x00000600UL
#define E1432_CLARINET_ADC_CHAN_FILOUT		0x00000700UL

#define E1432_CLARION_ADC_CHAN_DACOUT1		0x00000000UL
#define E1432_CLARION_ADC_CHAN_AMPOUT1		0x00000100UL
#define E1432_CLARION_ADC_CHAN_AMPOUT1_HIGAIN	0x00000200UL
#define E1432_CLARION_ADC_CHAN_DACOUT2		0x00000300UL
#define E1432_CLARION_ADC_CHAN_AMPOUT2		0x00000400UL
#define E1432_CLARION_ADC_CHAN_AMPOUT2_HIGAIN	0x00000500UL
#define E1432_CLARION_ADC_CHAN_CALOUT		0x00000600UL
#define E1432_CLARION_ADC_CHAN_GND		0x00000700UL

/* Data transfer settings for E1432_SRCx_XFRCMD_REG */
#define	E1432_SRC_XFRCMD_IDLE		0x00000000UL /* No transfer */
#define	E1432_SRC_XFRCMD_CONTA		0x00000001UL /* Continue xfer to A */
#define	E1432_SRC_XFRCMD_CONTB		0x00000002UL /* Continue xfer to B */
#define	E1432_SRC_XFRCMD_A		0x00000004UL /* Start xfer to A */
#define	E1432_SRC_XFRCMD_B		0x00000008UL /* Start xfer to B */
#define	E1432_SRC_XFRCMD_AB		0x00000010UL /* Start xfer to AB */
#define	E1432_SRC_XFRCMD_RESETA		0x00000080UL /* Reset xfer to A */
#define	E1432_SRC_XFRCMD_RESETB		0x00000100UL /* Reset xfer to B */

/* Service mode settings for E1432_SRCx_XFRCMD_REG - must be negative
   when converted to signed 32-bit int. */
#define	E1432_SRC_XFRCMD_DATA		0x80000001UL /* Write block of data */
#define	E1432_SRC_XFRCMD_DATACONT	0x80000002UL /* Continue sending it */
#define	E1432_SRC_XFRCMD_CMD		0x80000004UL /* One word to cmd port */
#define	E1432_SRC_XFRCMD_READ		0x80000008UL /* Read block of data */
#define	E1432_SRC_XFRCMD_READCONT	0x80000010UL /* Continue reading it */
#define	E1432_SRC_XFRCMD_READSTATUS	0x80000020UL /* Read status reg */
#define	E1432_SRC_XFRCMD_READID		0x80000040UL /* Read ID from src */
#define	E1432_SRC_XFRCMD_NACKCMD	0x80000080UL /* One word cmd, no ack */
#define	E1432_SRC_XFRCMD_READNCLRSTATUS	0x80000100UL /* No clr read status */

/* When  E1432_SRCx_XFRBUFFER_WORDCOUNT_REG is 0 then xfer buffer is ready for
new data.  WORDCOUNT is written after data block so that transfer from the
buffer will not start until the buffer is filled. */

#define E1432_SRC_XFRBUFFER_WORDCOUNT_EMPTY        0x00000000UL

/* E1432_SRC_XFRBUFFER_STATUS_REG bits,  mask and check for not zero: */
#define E1432_SRC_XFRBUFFER_STATUS_AFULL        0x00000001UL
#define E1432_SRC_XFRBUFFER_STATUS_AOUT         0x00000002UL
#define E1432_SRC_XFRBUFFER_STATUS_BFULL        0x00000100UL
#define E1432_SRC_XFRBUFFER_STATUS_BOUT         0x00000200UL

/*****************************************************************************/
/* Bit definitions                                                           */
/*****************************************************************************/

/* These must match the Vibrato CSR bits in subst/vibrato.h */
#define	E1432_FLAG_HALF			0x1
#define	E1432_FLAG_OVERLOAD_DIFF	0x2
#define	E1432_FLAG_OVERLOAD_COMM	0x4

#define	E1432_FLAG_CAL_FAILURE_FW       0x0001 /* cal FW failure */
#define	E1432_FLAG_CAL_FAILURE_SUB_FW   0x0002 /* failure in FW called by cal*/
#define	E1432_FLAG_CAL_FAILURE_FIFO	0x0004 /* FIFO didn't fill */
#define	E1432_FLAG_CAL_FAILURE_NO_CONST 0x0008 /* no substrate cal constants */
#define	E1432_FLAG_CAL_FAILURE_GAIN     0x0010 /* computed gain const OOR */
#define	E1432_FLAG_CAL_FAILURE_OFFSET   0x0020 /* computed offset const OOR */
#define	E1432_FLAG_CAL_FAILURE_OORL	0x0040 /* measured data OOR low */
#define	E1432_FLAG_CAL_FAILURE_OORH	0x0080 /* measured data OOR high */
#define	E1432_FLAG_CAL_FAILURE_CONSTANT 0x0100 /* constant data */
#define	E1432_FLAG_CAL_FAILURE_UNSTABLE 0x0200 /* too variable data */
#define	E1432_FLAG_CAL_FAILURE_NDS	0x0400 /* negative data squared */
#define	E1432_FLAG_CAL_FAILURE_SSO	0x0800 /* squared sum overflow */
/* additional info bits */
#define	E1432_CAL_FAIL_LOW_GAIN		0x1000 /* low gain setting */
#define	E1432_CAL_FAIL_HIGH_GAIN	0x2000 /* high gain setting */
/* a bit for each pass */
#define	E1432_CAL_FAIL_PASS0		0x00010000 /* base bit - pass 0 */
#define	E1432_CAL_FAIL_MAX_PASS			 8 /* 8 pass bits allocated */
#define	E1432_CAL_FAIL_PASS_MASK	0x00ff0000 /* 8 pass bits allocated */
/* Extra info used for E1432_FLAG_CAL_FAILURE_CONSTANT */
#define	E1432_CAL_FAIL_CONST_NEAR	0x01000000 /* near expected value */
#define	E1432_CAL_FAIL_CONST_FS_P	0x02000000 /* railed positive */
#define	E1432_CAL_FAIL_CONST_FS_N	0x04000000 /* railed negative */
#define	E1432_CAL_FAIL_CONST_ZERO	0x08000000 /* constant, 0 value */
#define	E1432_CAL_FAIL_CONST_OTHER	0x10000000 /* other constant value */

/* E1432_DIAG_MODES bits */
#define E1432_DIAG_MODE_NO_SRC_POLL	0x00001000 /* turn source polling off */
#define E1432_DIAG_MODE_NO_TACH_POLL	0x00002000 /* turn Tach polling off */

/* E1432_FLAGBITS_REG */
#define	E1432_FLAGBITS_SOFT_SYNC	0x1

/* i1432_dnld_fw_state in global.h - state of downloading substrate FW */
#define E1432_DNLD_FW_FAILED		0x00000001
#define E1432_DNLD_FW_SUCCESSFUL	0x00000002

/* definitions for E1432_LOST_POINT_REG */
#define E1432_LOST_CODE_MASK		0x000000FF
#define E1432_LOST_SCANS_MASK		0xFFFFFF00
#define E1432_LOST_SCANS_SHIFT		8

/*****************************************************************************/
/* Vibrato/Sonata definitions                                                */
/*****************************************************************************/

/* ISR with ID bits for Vibrato, Sonata */
#define	E1432_SCA_ISR			0xfd

/* Vibrato ISR ID bits */
#define E1432_VIB_ISR_FIXED_BITS 0x05f80000UL
#define E1432_VIB_ISR_FIXED_VALS 0x00080000UL

/* Sonata ISR ID bits */
#define E1432_SCA_ISR_SONATA_B_FIXED_MASK	0x00ffc200UL
#define E1432_SCA_ISR_SONATA_B_FIXED_BITS_A1	0x00ca0000UL /* B A1 */

/* upper half of a24 address space */
#define	E1432_A24_UPPER_1M		0x80000
#define	E1432_SCA_SPACING		0x00400	/* bytes */

/* Sonata SCA registers, all in words */
#define	E1433_SCA_SONATA_HDATA			0x00
#define	E1433_SCA_SONATA_HCR			0x14
#define	E1433_SCA_SONATA_CVR			0x15
#define	E1433_SCA_SONATA_HISR			0x16
#define	E1433_SCA_SONATA_GCTLR			0x20
#define	E1433_SCA_SONATA_IMR			0x21
#define	E1433_SCA_SONATA_ISR			0x22
#define	E1433_SCA_SONATA_GXCR			0x23

/* Sonata SCA register bits */
#define E1433_SCA_SONATA_HISR_TXDE		0x00000200L
#define	E1433_SCA_SONATA_ISR_BUS_ERR		0x0100
#define	E1433_SCA_SONATA_GXCR_ERR		0x04	/* o/s 0 FW error bit */
#define	E1433_SCA_SONATA_GCTLR_DSP_RST		0x00030000L /* resets dsp */

#define E1433_SCA_SONATA_EE_READ_ERRS		0x8600
#define E1433_SCA_SONATA_EE_ADDR		0x8700
#define E1433_SCA_SONATA_EE_DATA		0x8800
#define E1433_SCA_SONATA_EE_READ		0x8900
#define E1433_SCA_SONATA_EE_STAT		0x8a00
#define E1433_SCA_SONATA_EE_WRITE_EN		0x8b00
#define E1433_SCA_SONATA_EE_WRITE_DIS		0x8c00
#define E1433_SCA_SONATA_EE_WRITE		0x8d00
#define E1433_SCA_SONATA_EE_ERASE_ALL		0x8e00

/*****************************************************************************/
/* Miscellaneous definitions                                                 */
/*****************************************************************************/

#define E1432_DF_SETTLING		64 /* E1432/E1433 digital filters */

/* i1432_set_auto_zero */
#define	E1432_AUTO_ZERO_OFF		160
#define	E1432_AUTO_ZERO_ON		161
#define	E1432_AUTO_ZERO_DEF		E1432_AUTO_ZERO_OFF

/* set_trigger_source */
#define	E1432_TRIGGER_SOURCE_MANUAL	460
#define	E1432_TRIGGER_SOURCE_AUTO	461
#define	E1432_TRIGGER_SOURCE_INPUT	462
#define	E1432_TRIGGER_SOURCE_SOURCE	463
#define	E1432_TRIGGER_SOURCE_TACH	464
#define	E1432_TRIGGER_SOURCE_EXTERNAL	465

/* vxi memory accesses */
#define E1432_A24	1
#define E1432_A16	0

/* extra_io values for i1432_sicl_setup1(), i1432_fake_setup_sicl() */
#define E1432_EXTRA_IO_NONE	0
#define E1432_EXTRA_IO		1
#define E1432_EXTRA_IO_DIAG	2

/* Octave */

/* Octave debug modes (E1432_OCTAVE_DEBUG_REG) */
#define E1432_OCTAVE_DEBUG_FLOAT	0x00000004UL
#define E1432_OCTAVE_DEBUG_COUNT	0x00000008UL
#define E1432_OCTAVE_DEBUG_NO_CONVERT	0x00000100UL
#define E1432_OCTAVE_DEBUG_NO_AVG	0x00000200UL
#define E1432_OCTAVE_DEBUG_NO_ANA_CRTN	0x00001000UL
#define E1432_OCTAVE_DEBUG_NO_BAND_CRTN	0x00002000UL
#define E1432_OCTAVE_DEBUG_ALL_BINS	0x00004000UL
#define E1432_OCTAVE_DEBUG_NO_DOWNLOAD	0x00008000UL

/* other Octave constants */
#define E1432_OCT_THIRD_FRAME_LENGTH	64
#define E1432_OCT_FULL_FRAME_LENGTH	64
#define E1432_OCT_WORD_LENGTH		32
#define E1432_OCT_SUB_LENGTH		16
#define E1432_OCT_SUB_POS		0
#define E1432_OCT_WORDS_PER_POINT	2

/******************************************************************************
 * defines for source flash rom segments (rev 3020 970103 and later )
 *****************************************************************************/
#define	E1432_SRC_USER_SEGADDR		0x00008000UL
#define	E1432_SRC_BDPARMS_SEGADDR	0x0000B000UL
#define	E1432_SRC_MONBOOT_SEGADDR	0x0000C000UL
#define E1432_SRC_MONBOOT_MAXSIZE	0x00000180UL
#define	E1432_SRC_MONVECTS_SEGADDR	0x0000C480UL
#define	E1432_SRC_MONVECTS_MAXSIZE	0x00000068UL
#define	E1432_SRC_SEGTBL_SEGADDR	0x0000C600UL
#define	E1432_SRC_SEGTBL_MAXSIZE	0x00000080UL
#define	E1432_SRC_MAIN0_SEGADDR		0x0000C780UL
#define	E1432_SRC_MAIN0_MAXSIZE		0x00003D80UL
#define	E1432_SRC_MAINY0_SEGADDR	0x00028000UL
#define	E1432_SRC_MAINY0_MAXSIZE	0x00000400UL
#define	E1432_SRC_SINE2_SEGADDR		0x00028C00UL
#define	E1432_SRC_SINE2_MAXSIZE		0x00000600UL
#define	E1432_SRC_RANDBB2_SEGADDR 	0x00029E00UL
#define	E1432_SRC_RANDBB2_MAXSIZE	0x00000A00UL
#define	E1432_SRC_RANDZ2_SEGADDR	0x0002BC00UL
#define	E1432_SRC_RANDZ2_MAXSIZE	0x00000A00UL
#define	E1432_SRC_ARBBB2_SEGADDR	0x0002DA00UL
#define	E1432_SRC_ARBBB2_MAXSIZE	0x00000B80UL
#define	E1432_SRC_SSINE2_SEGADDR	0x0002FC80UL
#define	E1432_SRC_SSINE2_MAXSIZE	0x00000B80UL
#define	E1432_SRC_ARBCMD1_SEGADDR	0x0003A100UL
#define	E1432_SRC_ARBCMD1_MAXSIZE	0x00000FA9UL
#define	E1432_SRC_GAUSSD_SEGADDR	0x0003CFFCUL
#define	E1432_SRC_GAUSSD_MAXSIZE	0x00001000UL

/******************************************************************************
 * Identification/Calibration structure(s) for Substrate Flash ROM.
 *
 * The cal structure is intended to be extensible.  So future extensions
 * don't break old code, code that reads it should check for a rev and
 * length >= what it needs, and ignore newer and longer.  This means
 * the cal block can only be extended, not changed.
 * Sema.bin built before Aug 1996 did not allow newer and longer, and needs
 * to see E1432_ID_CAL_R2.  So E1432_ID_CAL_R3 is a wraper around R2,
 * with a new rev & length word.
 ******************************************************************************/

/* Moved to e1432.h, since it is also used in the e1432_hwconfig structure */
/* #define	E1432_SERIAL_LENGTH 20 */

/* Substrate code assumes this always true for Sonata B. */
#define E1432_CAL_INFO_NEW_MDAC_BITS	0x00000001UL

typedef struct e1432_compressed_date
{
    /* 4 ASCI char/bytes each word */
    unsigned long year;  /* 4 characters, AD */
    unsigned long date;  /* month (most significant), day (2 bytes each) */
    unsigned long time;  /* hours (most significant), minutes (2 bytes each) */
}
E1432_COMPRESSED_DATE;

typedef struct e1432_fs_offset_block
{
    float offset;
    float full_scale;
}
E1432_FS_OFFSET_BLOCK;

typedef struct e1432_dc_cal_block
{
    E1432_COMPRESSED_DATE date;
    float gnd_offset;
    E1432_FS_OFFSET_BLOCK lo_range;
    E1432_FS_OFFSET_BLOCK hi_range;
}
E1432_DC_CAL_BLOCK;

/* the actual Rev 2 structure */
typedef struct e1432_id_cal_r2
{
    unsigned long rev_length;
    /* actually an ASCII string */
    /* sizeof(unsigned long) != 4 in 96k land */
    unsigned long serial[E1432_SERIAL_LENGTH/4];
    E1432_DC_CAL_BLOCK dc_cal;
    unsigned long board_date_code;
    	/* The board_date_code is an integer, 100 * (year-1960) +  week.
    	 * This is updated each time a PCO is implemented, and should
    	 * match a sticker on the board
    	 */
}
E1432_ID_CAL_R2;


#define	E1432_ID_CAL_R2_REV 2L
/* this value should be stored in id_cal.rev_length */
#define	E1432_ID_CAL_R2_REV_LENGTH (E1432_ID_CAL_R2_REV << 16) \
        + sizeof(E1432_ID_CAL_R2)


typedef  unsigned long  E1432_BOARD_NUM;
/* unsigned byte  - E14xx
   unsigned byte  - 665xx
   char           - rev (A, B, etc)
   unsigned byte  - rev number
 */

typedef struct e1432_sca_entry
{
    E1432_BOARD_NUM board_num;
    unsigned long board_date_code;	/* formatted same as for substrate */
    E1432_COMPRESSED_DATE cal_date;	/* date of cal */
    unsigned long chans;		/* number of channels */
    unsigned long ranges;		/* number of ranges on each channel */
    unsigned long entries;		/* number of entries for each range */
    unsigned long reserved[3];		/* for the future */
}
E1432_SCA_ENTRY;

/*
 * This is the total of all the cal constants for all of the scas.
 * For compatibility, it should never be decreased.
 * The maximum value is 960, which fills out the 4 kByte FPROM block.
 * The current value is for Sonata - 8 channels x 11 ranges x 2 entries per.
 */
#define E1432_SCA_CAL_BLOCKSIZE		176

typedef struct e1432_sca_info
{
    E1432_SCA_ENTRY sca[4];		/* info for each SCA */
    FLOATSIZ32 cal_const[E1432_SCA_CAL_BLOCKSIZE];	/* cal constants */
}
E1432_SCA_INFO;


/* the actual Rev 3 structure */
typedef struct e1432_id_cal_r3
{
    unsigned long rev_length_r2; /* = E1432_ID_CAL_R2_REV_LENGTH */
    /* keep rev_length_r2 = E1432_ID_CAL_R2_REV_LENGTH for  */
    /* compatability with sema.bin <19960801. use rev_length below.  */
    unsigned long serial[E1432_SERIAL_LENGTH/4];
    /* actually an ASCII string */
    /* sizeof(unsigned long) != 4 in 96k land */
    E1432_DC_CAL_BLOCK dc_cal;
    unsigned long board_date_code;
    	/* The board_date_code is an integer, 100 * (year-1960) +  week.
    	 * This is updated each time a PCO is implemented, and should
    	 * match a sticker on the board
    	 */
    unsigned long rev_length;	/* the active rev_length */
    E1432_BOARD_NUM board_num;
    unsigned long reserved[3];	/* for the future */
    E1432_SCA_INFO sca_info;
}
E1432_ID_CAL_R3;


#define	E1432_ID_CAL_R3_REV 3L
/* this value should be stored in id_cal.rev_length */
#define	E1432_ID_CAL_R3_REV_LENGTH (E1432_ID_CAL_R3_REV << 16) \
        + sizeof(E1432_ID_CAL_R3)


/* Due to errors in the way E1433 rev 3 cal constants got computed, we
   must add a gain and offset correction-to-the-correction value, one
   pair per channel.  We need at most eight channels times 2 values,
   plus a flag to tell us whether the values are there. */
#define	EXTRA_SCA_INFO_BLOCKSIZE	16
struct extra_sca_info
{
    LONGSIZ32 extra_info_valid[4]; /* One for each SCA */
    FLOATSIZ32 cal_const[EXTRA_SCA_INFO_BLOCKSIZE];
};

/* The actual Rev 4 structure */
typedef struct e1432_id_cal_r4
{
    /* Keep rev_length_r2 = E1432_ID_CAL_R2_REV_LENGTH for
       compatability with sema.bin <19960801.  Use rev_length below
       instead. */
    unsigned long rev_length_r2; /* = E1432_ID_CAL_R2_REV_LENGTH */
    /* The serial is actually an ASCII string */
    /* Note sizeof(unsigned long) != 4 in 96k land */
    unsigned long serial[E1432_SERIAL_LENGTH/4];
    E1432_DC_CAL_BLOCK dc_cal;
    /* The board_date_code is an integer, 100 * (year-1960) + week.
       This is updated each time a PCO is implemented, and should
       match a sticker on the board */
    unsigned long board_date_code;

    /* New for Rev 3 */
    unsigned long rev_length;	/* The real rev_length */
    E1432_BOARD_NUM board_num;
    unsigned long cal_info;	/* formerly reserved, see E1432_CAL_INFO bits */
    unsigned long reserved[2];
    E1432_SCA_INFO sca_info;

    /* New for Rev 4 */
    struct extra_sca_info extra_sca_info;
}
E1432_ID_CAL_R4;

/* Rev 4 structure for on-sca cal constants.
   There is one FPROM per SCA connector (as opposed to SCA board).
   However, the exising Rev 4 structure is programmed as 2 (physical) SCA
   blocks of 4 channels each.
   So this structure is designed to contain 4 channels worth of information
   and EEPROM on the second SCA connector is not currently used.
   The EEPROM used is on the P2 SCA bus connector, which is SCA 0 and SCA 4
   on the SCA bus.
   Size is 113 words out of 128 words available - 15 unused plus the EEPROM
   on the P1 SCA bus connector.  */
typedef struct e1432_sca_cal_r4
{
    unsigned long rev_length;

    unsigned long reserved[4];		/* future */

    /* the R3 data */
    E1432_SCA_ENTRY sca;		/* info for each SCA */
    FLOATSIZ32 sca_cal_const[E1432_SCA_CAL_BLOCKSIZE/2]; /* cal constants */

    /* the additional, R4 data */
    LONGSIZ32 extra_info_valid;		/* One for each SCA connector */
    FLOATSIZ32 extra_sca_cal_const[EXTRA_SCA_INFO_BLOCKSIZE/2];
}
E1432_SCA_CAL_R4;

#define	E1432_ID_CAL_R4_REV		4L
/* This value should be stored in id_cal.rev_length: */
#define	E1432_ID_CAL_R4_REV_LENGTH	(E1432_ID_CAL_R4_REV << 16) +\
					sizeof(E1432_ID_CAL_R4)
/* ...and this one in sca_cal.rev_length */
#define	E1432_SCA_CAL_R4_REV_LENGTH	((E1432_ID_CAL_R4_REV << 16) +\
					SIZEOF(E1432_SCA_CAL_R4))
/* This one in first word of second EEPROM, for test purposes */
#define	E1432_SCA_CAL_R4_REV_LENGTH_2	(E1432_ID_CAL_R4_REV << 16)

#define E1432_ID_CAL_LATEST		E1432_ID_CAL_R4
#define E1432_ID_CAL_REV_LATEST		E1432_ID_CAL_R4_REV
#define E1432_ID_CAL_REV_LENGTH_LATEST	E1432_ID_CAL_R4_REV_LENGTH

/* Substrate FLASH parm2 block definition */
#define E1432_PARM2_R1		0L		/* revision number 1 */
#define E1432_PARM2_R_CURR	E1432_PARM2_R1	/* current revision */
/* word numbers, revision 1 */
#define E1432_PARM2_REV		0	/* revision (E1432_PARM2_R1) */
#define E1432_PARM2_RES1	1	/* 0, reserved for future expansion */
#define E1432_PARM2_RES2	2	/* 0, reserved for future expansion */
#define E1432_PARM2_NUM_OPTS	3	/* number of options in optionList */
#define E1432_PARM2_OPT_LIST	4	/* first option in list (1 word ea) */

#define	E1432_FPROM_PARM_BLOCKSIZE	1024	/* 32 bit words, 4096 bytes */

/* programming options */
#define	E1432_PROG_NOP		0	/* do nothing */
#define	E1432_PROG_CLEAR	1	/* clear all entries */
#define	E1432_PROG_DELETE	2	/* delete one entry */
#define	E1432_PROG_ADD		3	/* add one entry */


/*****************************************************************************/
/* Tach parameter structure                                                  */
/*****************************************************************************/
struct e1432_tach_parms {
    float   pre_arm_rpm;
    float   rpm_high;
    float   rpm_interval;
    float   rpm_low;
    float   rpm_smoothing;
    long    tach_decimate;	/* Count */
    float   tach_holdoff;	/* Seconds */
    float   tach_max_time;	/* Seconds */
    float   tach_ppr;		/* counts */
    int	    active;
    int	    is_arming_chan;	/* new for EDF_BRANCH */
    int	    arm_chan_index;	/* not used in EDF_BRANCH */
    int	    trigger_delay;
    int	    trigger_channel;
    int     raw_tach_size;
};


/*****************************************************************************/
/* Function prototypes                                                       */
/*****************************************************************************/

extern SHORTSIZ16 EXPORT
e1432_set_trig_hi(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_trig_hi(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_trig_lo(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_trig_lo(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_tach_raw_size(E1432ID, SHORTSIZ16, LONGSIZ32 *);

extern SHORTSIZ16 EXPORT
e1432_set_trigger_index(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_trigger_index(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_trigger_flag(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_trigger_flag(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_raw_tachs_done(E1432ID, SHORTSIZ16, LONGSIZ32);

/* Internal per channel commands.  Production test uses these so we
   can't change the names to i1432_xxx. */
extern SHORTSIZ16 EXPORT
e1432_get_cal_failures(E1432ID hw, SHORTSIZ16 ID, LONGSIZ32 * value);
extern SHORTSIZ16 EXPORT
e1432_get_cal_gain(E1432ID hw, SHORTSIZ16 ID, FLOATSIZ32 * value);
extern SHORTSIZ16 EXPORT
e1432_get_cal_gain2(E1432ID hw, SHORTSIZ16 ID, FLOATSIZ32 * value);
extern SHORTSIZ16 EXPORT
e1432_get_cal_offset(E1432ID hw, SHORTSIZ16 ID, FLOATSIZ32 * value);
extern SHORTSIZ16 EXPORT
e1432_get_cal_offset2(E1432ID hw, SHORTSIZ16 ID, FLOATSIZ32 * value);

/* From sys/crt096.cln, needed by sys and subst directories */
#ifdef	__DSP96K__
#include <sys/types.h>
extern void e1432_read_y(void *, void *);
extern void e1432_write_y(void *, void *);
extern void *e1432_xy_memcpy(void *, const void *, size_t);
extern void *e1432_yx_memcpy(void *, const void *, size_t);
#endif

/* internal, until e1432_set_meas_type() is fully implemented,
   replacing e1432_set_calc_data() */
extern SHORTSIZ16
e1432_set_meas_type(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16
e1432_get_meas_type(E1432ID, SHORTSIZ16, SHORTSIZ16 *);

/* variable externs */
/* diagnostics */
extern const char   DOS_FAR        e1432_null_str[];
extern const char * DOS_FAR const e1432_in32_str[];
extern const char * DOS_FAR const e1432_in33a_str[];
extern const char * DOS_FAR const e1432_in33b_str[];
extern const char * DOS_FAR const e1432_in_str[];
extern const char * DOS_FAR const e1432_src_str[];
extern const char   DOS_FAR        e1432_tach_str[];
extern const char * DOS_FAR const e1432_dsp33_str[];
extern const char * DOS_FAR const e1432_chan32[];
extern const char * DOS_FAR const e1432_chan33[];
extern const char * DOS_FAR const e1432_src_chan[];
extern const char * DOS_FAR const e1432_no_chan[];
extern const SHORTSIZ16 DOS_FAR e1432_32chan2sca[];
extern const SHORTSIZ16 DOS_FAR e1432_33chan2sca[];
extern const SHORTSIZ16 DOS_FAR e1432_fail32[];
extern const SHORTSIZ16 DOS_FAR e1432_fail33[];
extern const SHORTSIZ16 DOS_FAR e1432_fail_src[];

#endif  /* _E1432I_H */
